

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">Licenses</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Licenses</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <?php echo $__env->make('notify.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('notify.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="container-fluid">
                <div class="row">
                    <!-- left column -->
                    <div class="col-md-6">
                        <!-- general form elements -->
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Edit License</h3>
                            </div>
                            <!-- /.card-header -->
                            <!-- form start -->
                            <form role="form" method="post" action="<?php echo e(route('license.edit', $license->id)); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="name">IPv4:</label>
                                        <input type="text" class="form-control" value="<?php echo e($license->ip); ?>"
                                            name="ip" id="ip" placeholder="Ip">
                                    </div>
                                    <div class="form-group">
                                        <label>Software:</label>
                                        <?php
                                            $software = \App\Software::firstWhere('id', $license->software_id);
                                        ?>
                                        <input type="text" disabled class="form-control" value="<?php echo e($software->name); ?>"
                                            name="software_id" id="software" placeholder="Software">
                                    </div>
                                    <div class="form-group">
                                        <label for="name">License Key:</label>
                                        <input type="text" disabled class="form-control"
                                            value="<?php echo e($license->license_key); ?>" name="license_key" id="license_key"
                                            placeholder="">
                                    </div>
                                    <div class="form-group">
                                        <label for="end_at">Ordered On:</label>
                                        <input type="text" disabled class="form-control datetime"
                                            value="<?php echo e(\Carbon\Carbon::parse($license->created_at)->format('jS F Y')); ?>"
                                            name="end_at" id="end_at" placeholder="End At">
                                    </div>
                                    <div class="form-group">
                                        <label for="end_at">Expiry Date:</label>
                                        <input type="text" disabled class="form-control datetime"
                                            value="<?php echo e(\Carbon\Carbon::parse($license->end_at)->format('jS F Y')); ?>"
                                            name="end_at" id="end_at" placeholder="End At">
                                    </div>
                                    <!-- Software select -->


                                    <!-- select -->
                                    <div class="form-group">
                                        <label>Status</label>
                                        <?php if(time() < strtotime($license->end_at)): ?>
                                            <input type="text" disabled class="form-control"
                                                value="<?php echo e($license->status == 1 ? 'Active' : 'Suspended'); ?>" name="status"
                                                id="status" placeholder="Status">
                                        <?php else: ?>
                                            <input type="text" disabled class="form-control" value="Expired"
                                                name="status" id="status" placeholder="Status">
                                        <?php endif; ?>



                                    </div>
                                    <div class="form-group">
                                        <label for="end_at">License Type:</label>
                                        <input type="text" disabled class="form-control datetime"
                                            value="<?php echo e($license->type); ?>" name="end_at" id="end_at" placeholder="End At">
                                    </div>

                                    <div class="form-group">
                                        <?php
                                            $cmd = \App\Software::firstWhere('id', $license->software_id);
                                            $reseller = \App\Reseller::firstWhere('id', $license->reseller_id);
                                        ?>
                                        <label for="cmd">Installation Commands:</label>
                                        
    <textarea type="text" disabled class="form-control datetime" style="overflow: hidden; resize: none; height: auto;" name="cmd" id="cmd" placeholder="Installation Commands">
        <?php echo e(str_replace('{domain}', $reseller->domain, $cmd->cmd)); ?>

    </textarea>
</div>

<script>
    // Function to resize textarea based on its content
    function resizeTextarea() {
        var textarea = document.getElementById('cmd');
        textarea.style.height = 'auto'; // Reset height to auto
        textarea.style.height = textarea.scrollHeight + 'px'; // Set height to content height
    }

    // Call resizeTextarea initially and whenever the content changes
    document.addEventListener('DOMContentLoaded', function () {
        var textareas = document.querySelectorAll('textarea');
        textareas.forEach(resizeTextarea);
    });

    // Call resizeTextarea when the textarea is resized manually
    document.getElementById('cmd').addEventListener('input', function () {
        resizeTextarea(this);
    });
</script>
                                    </div>

                                </div>

                                <!-- /.card-body -->
                                <div class="card-footer text-left">
                                    <button type="submit" class="btn btn-primary">Make changes</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    </div>
                    <div class="col-md-6">
                    <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Basic Info</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                <div class="form-group">
                                        <label for="name">Hostname:</label>
                                        <span id="hostname"></span>
                                    </div>
                                </div>
                                <div id="server-status">
                                    Server Status: <span id="status-text"></span>
                                </div>
                            </div>
                        </div>
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Auto Renew</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <form method="post" action="<?php echo e(route('license.toggleAutoRenew', $license->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" name="auto_renew"
                                                    id="auto_renew" <?php echo e($license->auto_renew ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="auto_renew">
                                                    <?php echo e($license->auto_renew ? 'Auto Renew: On' : 'Auto Renew: Off'); ?>

                                                </label>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary">Save Auto Renew</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card -->
    </div><!-- /.container-fluid -->
    </section>
    <script>
        function getHostname(ipAddress) {
            fetch('/get-hostname?ip=' + ipAddress)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('hostname').textContent = data.hostname;
                })
                .catch(error => {
                    console.error('Error:', error);
                });
        }

        getHostname('<?php echo e($license->ip); ?>');
    </script>
<script>
    function checkServerStatus() {
        const ipAddress = "<?php echo e($license->ip); ?>"; // Get the IP address from Blade template

        fetch('/ping-server/' + ipAddress) // Pass IP address as a URL parameter
            .then(response => {
                if (response.ok) {
                    return response.text();
                } else {
                    throw new Error('Server is offline');
                }
            })
            .then(data => {
                document.getElementById('status-text').textContent = 'Online';
                document.getElementById('status-text').style.color = 'green';
            })
            .catch(error => {
                document.getElementById('status-text').textContent = 'Offline';
                document.getElementById('status-text').style.color = 'red';
            });
    }

    checkServerStatus();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/SysLic/public_html/admin/application/resources/views/licenses/edit.blade.php ENDPATH**/ ?>